--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A controller that moves an object along a path, while orienting it to face the travel direction. It has multiple options for the pointing and facing behaviours.
--- @class niPathController : niTimeController, niObject
--- @field allowFlip boolean Changes how the up vector of the local coordinate frame is calculated. When disabled, it will align towards the +Z axis. When enabled, it will use the local path derivatives with smoothing controlled by `smoothing`. This allows the object to turn upside down, but orientation changes at keyframes may be jerky.
--- @field bank boolean Controls if banking behaviour is enabled. The target object will roll so that its top side faces inside/outside the path, depending on `bankDirection`.
--- @field bank_related_data number Temporary name. Some other scalar property related to the banking logic.
--- @field bankDirection number The banking alignment direction used when `bank` mode is enabled. 1 = bank inside, -1 = bank outside.
--- @field constantVelocity boolean Controls if constant velocity behaviour is enabled. It specifies if the curve represented by the path keyframe data should be parameterized by arc length when enabled, or by time when disabled.
--- @field flipFollowAxis boolean Selects the + or - axis direction of the object that points along the path. Combines with `followAxis` to fully specify the axis.
--- @field follow boolean Controls if follow behaviour is enabled. This sets if the controller orients the target object to point along the path.
--- @field followAxis number Selects the axis of the object that points along the path. X = 0, Y = 1, Z = 2. Combines with `flipFollowAxis` to fully specify the axis.
--- @field lastUsedPathIndex number The last path position index that the game engine used.
--- @field lastUsedPercentIndex number The last path percent index that the game engine used.
--- @field maxBankAngle number Maximum bank angle in radians. Used when `bank` mode is enabled.
--- @field openCurve boolean Controls if the curve is open. This ensures correct wraparound for interpolation.
--- @field pathData niPosData *Read-only*. The path position animation data used by the controller.
--- @field percentData niFloatData *Read-only*. The path percent animation data used by the controller.
--- @field smoothing number Smoothing distance threshold parameter used by `allowFlip` mode.
--- @field totalLength number The calculated total arc length of the path.
